package cn.com.duiba.live.conf.service.api.param.conf;

import cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums;
import cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractTypeEnum;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 直播互动配置分页
 *
 * @author zouwx
 * @date 2022/08/22
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class LiveConfPageQueryParam extends PageQuery {

    private static final long serialVersionUID = 5298874394401552014L;

    /**
     * 互动id列表
     */
    private List<Long> interactIds;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 互动id
     */
    private Long interactId;

    /**
     * 互动类型：
     * @see LiveInteractTypeEnum
     */
    private Integer interactType;

    /**
     * 互动状态
     * @see InteractStatusEnums
     */
    private Integer interactStatus;
}
