package cn.com.duiba.live.conf.service.api.remoteservice.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.MallGoodsDetailDto;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.MallGoodsDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/8/9 6:10 下午
 **/
@AdvancedFeignClient
public interface RemoteMallSaleGoodsService {

    /**
     * 商品列表（访客端用） redis缓存5分钟
     *
     * @param liveId 直播id
     * @return 商品列表
     */
    List<MallGoodsDto> findGoodsListWithCache(Long liveId);

    /**
     * 商品详情（访客端用） redis缓存5分钟
     *
     * @param confId 商品配置id
     * @return 商品详情
     */
    MallGoodsDetailDto findGoodsDetailWithCache(Long confId);

    /**
     * 商品列表（助播端用）
     *
     * @param liveId 直播id
     * @param status {@link cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums}
     * @return 商品列表
     */
    List<MallGoodsDto> findGoodsList(Long liveId, List<Integer> status);

    /**
     * 批量更新状态
     *
     * @param confIds 配置id集合
     * @param status {@link cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums}
     * @return true-更新成功 false-更新失败
     */
    boolean batchUpdateStatus(List<Long> confIds, Integer status);

    /**
     * 批量添加商品
     * 1.更新状态为可售
     * 2.更新排序值
     *
     * @param liveId 直播id
     * @param confIds 配置id集合
     * @return true-添加成功 false-添加失败
     */
    boolean batchAdd(Long liveId, List<Long> confIds);

    /**
     * 调整排序值 将商品移动到指定商品位置
     *
     * @param liveId 直播id
     * @param originConfId 需要移动的商品
     * @param replacedConfId 被替换的商品
     * @return true-调整成功 false-调整失败
     */
    boolean adjustPosition(Long liveId, Long originConfId, Long replacedConfId);

    /**
     * 讲解
     *
     * @param liveId 直播id
     * @param confId 商品配置id
     * @return true-成功 false-失败
     */
    boolean explain(Long liveId, Long confId);

    /**
     * 取消讲解
     *
     * @param liveId 直播id
     * @param confId 商品配置id
     * @return true-成功 -false-失败
     */
    boolean cancelExplain(Long liveId, Long confId);
}
