package cn.com.duiba.live.conf.service.api.remoteservice.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.MallSaleSkuDto;

import java.util.List;
/**
 * @author xuzhigang
 * @date 2022/8/14 9:47 下午
 **/
@AdvancedFeignClient
public interface RemoteMallSaleSkuService {

    /**
     * 根据spuId查询
     * @param spuId spuId
     * @return 商城-售卖商品
     */
    List<MallSaleSkuDto> selectBySpuId(Long spuId);

    /**
     * 批量插入
     *
     * @param skuDtoList 售卖商品sku
     * @return true-插入成功 false-插入失败
     */
    boolean batchInsert(List<MallSaleSkuDto> skuDtoList);

    /**
     * 批量更新
     *
     * @param skuDtoList 售卖商品sku
     * @return true-插入成功 false-插入失败
     */
    boolean batchUpdate(List<MallSaleSkuDto> skuDtoList);

    /**
     * 扣库存
     *
     * @param id    skuId
     * @param delta 扣除库存数
     * @return 执行结果
     */
    int decreaseStock(Long id, Integer delta);

    /**
     * 根据spuId批量查询
     * @param spuIdList spuIdList
     * @return 商城-售卖商品
     */
    List<MallSaleSkuDto> selectBySpuIdList(List<Long> spuIdList);
}
