package cn.com.duiba.live.conf.service.api.remoteservice.pass;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesBaseConfRedisDto;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesConfDto;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesOptionDto;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesRedConfDto;
import cn.com.duiba.live.conf.service.api.dto.pass.LivePassQuesRedConfRedisDto;
import cn.com.duiba.live.conf.service.api.param.pass.LivePassQuesConfEditParam;
import cn.com.duiba.live.conf.service.api.param.pass.LivePassQuesRedEditParam;

import java.util.List;

/**
 * 闯关答题配置service
 * @author chentiecheng
 * @date 2021/6/18 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteLivePassQuesConfApiService {
    /**
     * 根据主键id查询配置
     * @param id 主键id
     * @return 详情
     */
    LivePassQuesRedConfDto selectById(Long id);

    /**
     * 切换开启关闭
     * @param id 配置id
     * @param openStatus 开启关闭状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesConfStatusEnum
     * @return 成功/失败
     */
    boolean switchStatus(Long id,Integer openStatus);

    /**
     * 新增活动配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean insertConf(LivePassQuesRedEditParam param);

    /**
     * 编辑活动配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean updateConf(LivePassQuesRedEditParam param);

    /**
     * 根据直播id查询配置详情
     * @param liveId 直播id
     * @return 详情
     */
    LivePassQuesRedConfDto findPassConfByLiveId(Long liveId);

    /**
     * 从redis中获取配置详情
     * @param liveId 直播id
     * @return 详情
     */
    LivePassQuesRedConfRedisDto selectRedisDtoByLiveId(Long liveId);

    /**
     * 从redis中获取配置基础详情
     * @param id 配置id
     * @return 详情
     */
    LivePassQuesBaseConfRedisDto selectRedisDtoById(Long id);



    /**
     * 更新问题状态
     * @param id 配置id
     * @param status 状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesStatusEnum
     * @return 成功/失败
     */
    boolean updateQuesStatus(Long id, Integer status);


    /**
     * 新增问题配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean insertQues(LivePassQuesConfEditParam param);

    /**
     * 编辑问题配置
     * @param param 详情
     * @return 成功/失败
     */
    boolean updateQues(LivePassQuesConfEditParam param);

    /**
     * 根据id 删除问题
     * @param id 主键id
     * @return 结果
     */
    boolean deleteQuesById(Long id);

    /**
     * 根据直播id查询问题列表
     * @param liveId 直播id
     * @return 详情
     */
    List<LivePassQuesConfDto> selectQuesListByLiveId(Long liveId);

    /**
     * 根据问题id查询详情
     * @param quesId 问题id
     * @return 详情
     */
    LivePassQuesConfDto selectQuesById(Long quesId);

    /**
     * 根据问题id查询选项列表
     * @param quesId 问题id
     * @return 选项列表
     */
    List<LivePassQuesOptionDto> selectOptionListByQuesId(Long quesId);

    /**
     * 上架红包
     * @param liveId 直播id
     * @return 结果
     */
    boolean shelfRed(Long liveId);
    /**
     * 修改红包状态
     * @param id 配置id
     * @param status 红包状态
     * @return 结果
     */
    boolean updateRewardStatus(Long id,Integer status);

}
