package cn.com.duiba.live.conf.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 秒杀优惠券-领取方式
 *
 * @author ZhangJun
 * @date 2021/12/10 11:29 上午
 */
@Getter
@AllArgsConstructor
public enum LiveCouponsReceiveTypeEnum {

    FILL_FORM(1, "填写表单"),
    COMPLETE_TEST(2, "完成测试"),
    ;

    /**
     * 领取方式
     */
    private Integer receiveType;

    /**
     * 领取方式描述
     */
    private String desc;

    private static final Map<Integer, LiveCouponsReceiveTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(LiveCouponsReceiveTypeEnum.values()).collect(Collectors.toMap(LiveCouponsReceiveTypeEnum::getReceiveType, Function.identity()));
    }

    public static LiveCouponsReceiveTypeEnum getByType(Integer receiveType) {
        if (receiveType == null) {
            return null;
        }
        return ENUM_MAP.get(receiveType);
    }

}
