package cn.com.duiba.live.conf.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.livetest.LiveTestRelationDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-02-20 16:28
 * @descript 测试直播remoteSerivce
 */
@AdvancedFeignClient
public interface RemoteLiveTestApiService {

    /**
     * 根据测试直播id查询
     * @param companyId
     * @param testLiveId
     * @return
     */
    LiveTestRelationDto selectByTestLiveId(Long companyId, Long testLiveId);

    /**
     * 根据源直播间查询
     * @param companyId
     * @param sourceLiveId
     * @return
     */
    LiveTestRelationDto selectBySourceLiveId(Long companyId, Long sourceLiveId);

    /**
     * 新增记录
     * @param liveTestDto
     * @return
     */
    Long save(LiveTestRelationDto liveTestDto);

    /**
     * 根据主键更新id 并自增更新次数
     * @param liveTestDto
     * @return
     */
    int updateByIdAndIncreateTime(LiveTestRelationDto liveTestDto);

    /**
     * 根据主键更新id
     * @param liveTestDto
     * @return
     */
    int updateById(LiveTestRelationDto liveTestDto);

    /**
     * 删除测试直播间相关的数据
     * @param id
     */
    void deleteLiveTestData(Long id);

    /**
     * 初始化测试直播间 复制正式直播间数据
     * @param id
     */
    boolean initLiveTestData(Long id);

    /**
     * 根据id查询数据
     * @param id
     * @return
     */
    LiveTestRelationDto selectById(Long id);

    /**
     * 根据测试直播id查询列表
     * @param liveIds
     * @return
     */
    List<LiveTestRelationDto> listByTestLiveIds(List<Long> liveIds);
}
