package cn.com.duiba.live.conf.service.api.remoteservice.mall.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.activity.MallPickActivityDto;

import java.util.List;

/**
 * 商城-选品活动
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallPickActivityService {
     
    /**
     * 查询所有
     *
     * @return 商城-选品活动集合
     */
    List<MallPickActivityDto> listAll();

    /**
     * 分页查询
     *
     * @param offset  分页偏移量
     * @param pageSize 分页大小
     * @return 分页结果
     */
    List<MallPickActivityDto> pageList(Integer offset, Integer pageSize);

    /**
     * 统计所有记录数量
     *
     * @return 数量
     */
    Long countAll();

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-选品活动
     */
    MallPickActivityDto selectById(Long id);

    /**
     * 批量根据主键集合查询
     *
     * @param ids 主键集合
     * @return 商城-选品活动
     */
    List<MallPickActivityDto> selectByIds(List<Long> ids);

    /**
     * 新增
     *
     * @param dto 商城-选品活动
     * @return 执行结果
     */
    boolean insert(MallPickActivityDto dto);

    /**
     * 更新
     *
     * @param dto 商城-选品活动
     * @return 执行结果
     */
    boolean update(MallPickActivityDto dto);
}