package cn.com.duiba.live.conf.service.api.enums.potential;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 代理人客户邀请类型枚举
 *
 * @author ZhangJun
 * @date 2021/8/19 11:41 上午
 */
@Getter
@AllArgsConstructor
public enum AgentDirectlyEnum {

    /**
     * 一度人脉/直接邀请
     */
    DIRECTLY(1, "直接邀请"),

    /**
     * 多度人脉/间接邀请
     */
    NOT_DIRECTLY(0, "间接邀请"),
    ;

    /**
     * 邀请类型
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, AgentDirectlyEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(AgentDirectlyEnum::getCode, Function.identity())));

    /**
     * 获取所有的枚举key
     *
     * @return 枚举key集合
     */
    public static List<Integer> allTypes() {
        return Lists.newArrayList(ENUM_MAP.keySet());
    }

    /**
     * 获取枚举
     */
    public static AgentDirectlyEnum getEnum(Integer code) {
        return ENUM_MAP.get(code);
    }

}
