/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.common;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CommonConfigSwitchEnum {
    CLOSE(0, "\u5173\u95ed"),
    OPEN(1, "\u5f00\u542f");

    private final Integer type;
    private final String message;
    private static final Map<Integer, CommonConfigSwitchEnum> SWITCH_ENUM_MAP;

    private CommonConfigSwitchEnum(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    public static CommonConfigSwitchEnum getByType(Integer type) {
        CommonConfigSwitchEnum switchEnum = SWITCH_ENUM_MAP.get(type);
        if (Objects.isNull((Object)switchEnum)) {
            return CLOSE;
        }
        return switchEnum;
    }

    public Integer getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    static {
        SWITCH_ENUM_MAP = Arrays.stream(CommonConfigSwitchEnum.values()).collect(Collectors.toMap(CommonConfigSwitchEnum::getType, Function.identity(), (v1, v2) -> v2));
    }
}

