/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.potential;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LiveDialogueTypeEnum {
    AGENT_GREET(1, "\u4ee3\u7406\u4eba\u6b22\u8fce\u8bed"),
    QUESTION(2, "\u63a8\u8350\u95ee\u9898"),
    PROMISE_CARD(3, "\u627f\u8bfa\u5361\u7247"),
    CUSTOMER_PROMISE(4, "\u5ba2\u6237\u884c\u52a8\u627f\u8bfa"),
    AGENT_CONCLUSION(5, "\u4ee3\u7406\u4eba\u7ed3\u675f\u8bed");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, LiveDialogueTypeEnum> ENUM_MAP;
    private static final Map<Integer, LiveDialogueTypeEnum> DIRECT_CONTENT_TYPE_MAP;

    public static boolean containsType(Integer type) {
        return ENUM_MAP.containsKey(type);
    }

    public static boolean isDirectContent(Integer type) {
        return DIRECT_CONTENT_TYPE_MAP.containsKey(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private LiveDialogueTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LiveDialogueTypeEnum.values()).collect(Collectors.toMap(LiveDialogueTypeEnum::getType, Function.identity())));
        DIRECT_CONTENT_TYPE_MAP = Collections.unmodifiableMap(Lists.newArrayList((Object[])new LiveDialogueTypeEnum[]{AGENT_GREET, CUSTOMER_PROMISE, AGENT_CONCLUSION}).stream().collect(Collectors.toMap(LiveDialogueTypeEnum::getType, Function.identity())));
    }
}

