package cn.com.duiba.live.conf.service.api.enums.conf;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播公司扩展配置
 *
 * @author ZhangJun
 * @date 2021/8/10 7:52 下午
 */
@AllArgsConstructor
@Getter
public enum LiveCompanyExtEnum {

    /**
     * 准客户功能开关，0-关闭，1-开启
     */
    POTENTIAL_SWITCH(1, "准客户功能开关"),
    ;

    /**
     * 键，取值区间为[1,255]
     */
    private final Integer key;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveCompanyExtEnum> ENUM_MAP= Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveCompanyExtEnum::getKey, Function.identity())));

    /**
     * 根据key获取枚举
     *
     * @param key 键
     * @return 枚举值
     */
    public static LiveCompanyExtEnum getByType(Integer key) {
        if (NumberUtil.isNullOrLteZero(key)) {
            return null;
        }

        return ENUM_MAP.get(key);
    }

    /**
     * 是否存在该key
     *
     * @param key 需要判断的key
     * @return true=存在，false=不存在
     */
    public static boolean contains(Integer key) {
        if (NumberUtil.isNullOrLteZero(key)) {
            return false;
        }

        return ENUM_MAP.containsKey(key);
    }

    /**
     * 获取直播公司配置key集合
     *
     * @return 配置key集合
     */
    public static List<Integer> allKeys() {
        return Lists.newArrayList(ENUM_MAP.keySet());
    }
}
