package cn.com.duiba.live.conf.service.api.dto.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商城-商品详情
 *
 * @author xuzhigang
 * @date 2022/8/9 5:27 下午
 **/
@Data
public class MallGoodsDetailDto implements Serializable {
    private static final long serialVersionUID = 7482230083247323842L;

    /**
     * 商品spuId tb_mall_sale_spu.id
     */
    private Long spuId;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型
     * @see cn.com.duiba.live.conf.service.api.enums.mall.MallBizTypeEnum
     */
    private Integer bizType;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 按钮标题
     */
    private String buttonTitle;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品名称
     */
    private String goodsBrand;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品主图列表
     */
    private List<String> mainImgUrls;

    /**
     * 商品详情图列表
     */
    private List<String> detailImgIds;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 是否需要发货审核0-不需要 1-需要
     */
    private Integer deliveryAudit;

    /**
     * 最大购买数量
     */
    private Integer maxBuyNum;

    /**
     * 发货地址
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 限制购买区域名称
     */
    private String limitRegionName;

    /**
     * 限制购买区域编码
     */
    private String limitRegionCode;

    /**
     * 规格属性列表
     */
    private List<AttributeDto> attributeList;

    /**
     * sku明细列表
     */
    private List<MallSaleSkuDto> skuDetailList;

    /**
     * 买家须知图片
     */
    private String buyerNoticeImgUrl;

    /**
     * 配送方式 1-订单配送 2-代理人自送
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.salegoods.DeliveryWayTypeEnum}
     */
    private Integer deliveryWay;

}
