package cn.com.duiba.live.conf.service.api.dto.second.kill;

import lombok.Data;

import java.io.Serializable;

/**
 * @author guoxuebiao
 * @date 2021/10/13 7:37 下午
 */
@Data
public class LiveSecondKillGoodsChargeDto implements Serializable {

    private static final long serialVersionUID = 5394546831310596L;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 秒杀价格
     */
    private Integer goodsAmount;

    /**
     * 商品数量
     */
    private Integer interactNum;

    /**
     * 代理人能否参加 0-否 1-是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer ableAgent;

    /**
     * 是否需要秒杀资格 0-否 1-是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     * @deprecated 使用playType字段标识
     */
    @Deprecated
    private Integer isNeedQualified;

    /**
     * 高级玩法类型，0-无配置，1-秒杀资格，2-秒杀优惠券
     * {@link cn.com.duiba.live.conf.service.api.enums.goods.LiveSecondKillPlayTypeEnum}
     */
    private Integer playType;

    /**
     * 秒杀资格直播助力人数
     */
    private Integer assistPeopleNum;

    /**
     * 秒杀资格抽卡必中配置
     */
    private LiveSecondKillCardConfigDto infallibleConfig;

    /**
     * 秒杀资格抽卡配置1
     */
    private LiveSecondKillCardConfigDto cardConfigOne;

    /**
     * 秒杀资格抽卡配置2
     */
    private LiveSecondKillCardConfigDto cardConfigTwo;

    /**
     * 秒杀资格助力限制
     */
    private Integer assistLimit;

    /**
     * 券后价，单位：分
     */
    private Integer afterPrice;

    /**
     * 优惠券领取方式，1-提交表单，2-完成测试
     * {@link cn.com.duiba.live.conf.service.api.enums.goods.LiveCouponsReceiveTypeEnum}
     */
    private Integer receiveType;

    /**
     * 优惠券关联资料id
     */
    private Long resourceConfId;
}
