package cn.com.duiba.live.conf.service.api.dto.mall.salegoods;

import lombok.Data;

import java.io.Serializable;

/**
 * 商城-售卖规格库存单元表
 * @author kjj mybatis generator 
 * @date 2022-08-09
 */
@Data
public class MallSaleSkuDto implements Serializable {
     
    private static final long serialVersionUID = 16600253495449584L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 售卖商品id tb_mall_sale_spu.id
     */
    private Long spuId;

    /**
     * 商品库规格库存id，tb_mall_goods_sku.id
     */
    private Long goodsSkuId;

    /**
     * sku图片
     */
    private String skuImg;

    /**
     * 售价 存分
     */
    private Integer discountedPrice;

    /**
     * 市场价 存分
     */
    private Integer marketPrice;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 剩余库存
     */
    private Integer surplusStock;

    /**
     * 供货价，单位：分
     */
    private Integer supplyPrice;

    /**
     * 规格属性配置json，格式为keyId:valueId，如{1:2,3:4}，key为tb_attribute_key.id，value为tb_attribute_value.id
     */
    private String attributeConfig;

    /**
     * 是否启用 0-未启用 1-已启用
     */
    private Integer enableStatus;
}