package cn.com.duiba.live.conf.service.api.dto.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商城商品信息
 *
 * @author xuzhigang
 * @date 2022/8/9 4:28 下午
 **/
@Data
public class MallGoodsDto implements Serializable {

    private static final long serialVersionUID = 4322648347365688620L;

    /**
     * 商品配置id
     */
    private Long confId;

    /**
     * 售卖商品id
     */
    private Long spuId;

    /**
     * 主图地址
     */
    private String mainImgUrl;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 按钮标题
     */
    private String buttonTitle;

    /**
     * sku列表
     */
    private List<MallSaleSkuDto> skuList;

    /**
     * 互动配置类型 26表示售卖商品
     * {@link cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractTypeEnum}
     */
    private Integer type;

    /**
     * 排序值
     */
    private Integer sort;

    /**
     * 0-未添加到商品库 2-可售 3-待售 4-售罄
     * {@link cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums}
     */
    private Integer status;

    /**
     * 是否正在讲解中 true-讲解中 false-不在讲解中
     */
    private Boolean explaining;

    /******************************非售卖商品属性*****************************/

    /**
     * 外链
     */
    private String outLink;

    /**
     * 外链类型
     * {@link cn.com.duiba.live.conf.service.api.enums.resource.OutLinkTypeEnum}
     */
    private Integer outLinkType;

    /**
     * 外链appId 外链类型为小程序时需要传
     */
    private String outLinkAppId;

    /**
     * 资料大图
     */
    private String resourceBigImg;

    /**
     * 测评id
     */
    private Long evaluationId;

    /**
     * 资料关联的通用配置id
     */
    private Long resourceConfId;
}
