package cn.com.duiba.live.conf.service.api.remoteservice.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.MallSaleSkuDto;
import cn.com.duiba.live.conf.service.api.param.mall.salegoods.SaleGoodsStockParam;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2022/8/14 9:47 下午
 **/
@AdvancedFeignClient
public interface RemoteMallSaleSkuService {

    /**
     * 根据主键id批量查询
     *
     * @param ids 主键id集合
     * @return 商城-售卖规格库存单元集合
     */
    List<MallSaleSkuDto> selectByIds(List<Long> ids);

    /**
     * 根据spuId查询
     * @param spuId spuId
     * @return 商城-售卖商品
     */
    List<MallSaleSkuDto> selectBySpuId(Long spuId);

    /**
     * 批量插入
     *
     * @param skuDtoList 售卖商品sku
     * @return true-插入成功 false-插入失败
     */
    boolean batchInsert(List<MallSaleSkuDto> skuDtoList);

    /**
     * 批量更新
     *
     * @param skuDtoList 售卖商品sku
     * @return true-插入成功 false-插入失败
     */
    boolean batchUpdate(List<MallSaleSkuDto> skuDtoList);

    /**
     * 扣库存
     *
     * @param id    skuId
     * @param delta 扣除库存数
     * @return 执行结果
     */
    int decreaseStock(Long id, Integer delta);

    /**
     * 批量扣库存(各业务结束场景,与订单无关,只扣库存不加销量)
     *
     * @param id2StockMap key: id value: stock
     * @return 执行结果
     */
    int batchDecrStock(Map<Long, Integer> id2StockMap);

    /**
     * 根据spuId批量查询
     * @param spuIdList spuIdList
     * @return 商城-售卖商品
     */
    List<MallSaleSkuDto> selectBySpuIdList(List<Long> spuIdList);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-售卖规格库存单元
     */
    MallSaleSkuDto selectById(Long id);

    /**
     * 批量添加库存
     * 实际上还是单个单个执行sql
     *
     * @param paramList 参数列表
     * @param spuId    商品id
     * @return boolean
     */
    boolean batchAddStock(List<SaleGoodsStockParam> paramList, Long spuId);

    /**
     * 增加剩余库存-回退库存用
     *
     * @param skuId       sku id
     * @param stockNum    库存
     * @return {@link Boolean}
     */
    boolean incrSurplusStock(Long skuId, Integer stockNum);

    /**
     * 删除售卖信息
     *
     * @param spuIdList       spu id
     * @return {@link Boolean}
     */
    boolean deleteBySpuIdList(List<Long> spuIdList);
}
