package cn.com.duiba.live.conf.service.api.dto.bank.card;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 银行卡活动配置
 * @author kjj mybatis generator 
 * @date 2022-08-31
 */
@Data
public class BankCardActivityDto implements Serializable {

    private static final long serialVersionUID = -58550837362310309L;
    /**
     * id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 银行卡名称
     */
    private String activityName;

    /**
     * 模板类型
     */
    private String templateType;

    /**
     * 活动类型,1=礼品限购
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.BankCardActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 银行卡id
     */
    private Long bankCardId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 活动未到/过期降级行为类型,1=跳转办卡页,2=显式提示页
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.BankActivityDowngradeTypeEnum
     */
    private Integer downgradeType;

    /**
     * 限购数量
     */
    private Integer restrictCount;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 活动状态,0=默认,1=已失效
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.BankActivityStatusEnum
     */
    private Integer activityStatus;
}