package cn.com.duiba.live.conf.service.api.enums.conf;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播代理人激活方式
 * @author lizhi
 * @date 2022/9/21 10:38 上午
 */
@AllArgsConstructor
@Getter
public enum LiveAgentActivateTypeEnum {
    MP_QR_CODE(1, "直接激活"),
    SUBSCRIBE_OA(2, "关注公众号激活"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveAgentActivateTypeEnum> ENUM_MAP= Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveAgentActivateTypeEnum::getType, Function.identity())));

    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举
     */
    public static LiveAgentActivateTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
