package cn.com.duiba.live.conf.service.api.enums.conf;

/**
 * 直播互动扩展枚举
 * @author chentiecheng
 * @date 2021-03-26 15:07
 **/
public enum LiveInteractExtNameEnum {

    LOTTERY_TYPE(1,"奖品类型"),
    LOTTERY_TEAM_CONF_STATUS(2,"抽奖团队份数配置开关"),
    LOTTERY_TEAM_CONF_TOTAL_NUM(3,"抽奖团队总份数"),
    AGENT_CAN_RECEIVE(4,"公司代理人能否领取奖品开关"),
    SECOND_KILL_GOODS_PRICE(5, "秒杀商品价格"),
    @Deprecated
    NEED_SECOND_KILL_QUALIFICATION(6, "是否需要秒杀资格"),
    SECOND_KILL_PLAY_TYPE(6, "秒杀高级玩法类型"),
    SECOND_KILL_QUALIFICATION_ASSIST_PEOPLE_NUM(7, "秒杀资格直播助力人数"),
    SECOND_KILL_INFALLIBLE_CONFIG(8, "秒杀资格抽卡必中配置"),
    SECOND_KILL_CARD_CONFIG_ONE(9, "秒杀资格抽卡配置1"),
    SECOND_KILL_CARD_CONFIG_TWO(10, "秒杀资格抽卡配置2"),
    SECOND_KILL_ASSIST_LIMIT(11, "秒杀资格助力限制"),
    LIVE_SURVEY_REWARD_SURVEY_URL(12, "直播问券有奖问卷地址"),
    LIVE_SURVEY_REWARD_SURVEY_ID(13, "直播问券有奖问卷地址"),
    ;

    /**
     * 类型
     */
    private final Integer name;

    /**
     * 描述
     */
    private final String desc;

    LiveInteractExtNameEnum(Integer name , String desc){
        this.name  = name;
        this.desc  = desc;
    }

    public Integer getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }


}
