package cn.com.duiba.live.conf.service.api.enums.flip.word;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 翻牌集字-天降幸运活动状态
 *
 * @author ZhangJun
 * @date 2021/10/7 4:45 下午
 */
@Getter
@AllArgsConstructor
public enum LiveFlipLuckyStatusEnum {


    NOT_FINISHED(1,"未完成"),
    HAS_FINISHED(2,"已完成"),
    EXPIRED(3,"已过期"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static  final Map<Integer, LiveFlipLuckyStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveFlipLuckyStatusEnum::getStatus, Function.identity())));
    }

    public static LiveFlipLuckyStatusEnum getByStatus(Integer status) {
        if (Objects.isNull(status)) {
            return null;
        }

        return ENUM_MAP.get(status);
    }

}
