package cn.com.duiba.live.conf.service.api.enums.resource;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 外链类型枚举
 *
 * @author xuzhigang
 * @date 2020/7/16 14:08
 **/
@Getter
@AllArgsConstructor
public enum OutLinkTypeEnum {

    CUSTOMER_SERVICE_MESSAGE(1, "客服消息"),
    H5_LINK(2, "H5链接"),
    MINI_PROGRAMS(3, "小程序"),
    BANK_CARD_APPLY(4, "银行申卡页"),
    BANK_CARD_ACTIVITY(5, "办卡活动"),
    ;

    /**
     * 类型
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;
}
