package cn.com.duiba.live.conf.service.api.param.mall.salegoods;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 销售商品分页查询参数
 *
 * @author zouwx
 * @date 2022/08/17
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SaleGoodsPageParam extends PageQuery {

    private static final long serialVersionUID = -6841558857050497121L;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型
     * 业务类型 1-直播
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.MallBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品id
     */
    private Long goodsId;

}
