package cn.com.duiba.live.conf.service.api.remoteservice.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.form.FormFieldOptionScoreDto;
import cn.com.duiba.live.conf.service.api.dto.form.FormFieldDetailDto;
import cn.com.duiba.live.conf.service.api.dto.form.FormFieldDto;
import cn.com.duiba.live.conf.service.api.dto.form.FormFieldSimpleDto;

import java.util.List;
import java.util.Map;

/**
 * 表单字段rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 5:27 下午
 **/
@AdvancedFeignClient
public interface RemoteFormFieldApiService {

    /**
     * 新增（包含选项等信息）
     * @param detailDto 表单字段详情
     * @return 执行结果
     */
    FormFieldSimpleDto saveDetail(FormFieldDetailDto detailDto);

    /**
     * 更新（包含选项等信息）
     * @param detailDto 表单字段详情
     * @return 执行结果
     */
    FormFieldSimpleDto updateDetail(FormFieldDetailDto detailDto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 表单字段详情
     */
    FormFieldDetailDto findDetailById(Long id);

    /**
     * 根据主键ID查询
     * @param ids 主键
     * @return 表单字段集合
     */
    List<FormFieldDetailDto> selectDetailByIds(List<Long> ids);

    /**
     * 删除（同时删除表单中数据）
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 查询业务表单字段（固定+自定义字段）
     * @param formBizId 业务ID，为null则只查询固定字段
     * @param formBizType 业务类型
     * @see cn.com.duiba.live.conf.service.api.enums.form.FormBizTypeEnum
     * @return 表单字段集合
     */
    List<FormFieldDto> selectListByBiz(Long formBizId, Integer formBizType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 单字段
     */
    FormFieldDto selectById(Long id);

    /**
     * 查询得分大于0的选项，从本地缓存查询
     * @param liveId 直播ID
     * @return key：tb_form_field主键，value：对应有得分的选项集合
     */
    Map<Long, List<FormFieldOptionScoreDto>> findAddScoreOption(Long liveId);
}
