package cn.com.duiba.live.conf.service.api.remoteservice.mall.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.goods.MallGoodsDto;
import cn.com.duiba.live.conf.service.api.param.mall.goods.MallGoodsEsSearchParam;
import cn.com.duiba.live.conf.service.api.param.mall.goods.MallGoodsPageParam;
import cn.com.duiba.live.conf.service.api.param.mall.thirdparty.PickGoodsPageParam;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

/**
 * 商城-商品库
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsService {
     
    /**
     * 根据条件分页查询
     *
     * @param param 查询条件
     * @return 商城-商品库集合
     */
    List<MallGoodsDto> pageList(MallGoodsPageParam param);

    /**
     * 根据条件分页查询 from es
     *
     * @param param 查询条件
     * @return 总条数,商品库分页集合
     */
    Pair<Long, List<MallGoodsDto>> pageListEs(MallGoodsEsSearchParam param);


    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long pageCount(MallGoodsPageParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-商品库
     */
    MallGoodsDto selectById(Long id);

    /**
     * 新增
     * @param dto 商城-商品库
     * @return 执行结果
     */
    Long insert(MallGoodsDto dto);

    /**
     * 批量新增
     *
     * @param dtos 选品集合
     * @return 新增结果
     */
    boolean batchInsert(List<MallGoodsDto> dtos);

    /**
     * 更新
     * @param dto 商城-商品库
     * @return 执行结果
     */
    boolean update(MallGoodsDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return 商城-商品库
     */
    List<MallGoodsDto> selectByIds(List<Long> ids);

    /**
     * 根据选品活动分页查询选品
     *
     * @param pickActivityId 查询条件
     * @param offset 偏移量
     * @param pageSize 分页大小
     * @return 商城-选品库集合
     */
    List<MallGoodsDto> pageListByActivity(Long pickActivityId, Integer offset, Integer pageSize);

    /**
     * 根据选品活动id集合批量查询选品
     *
     * @param activityIds 选品活动id
     * @return 选品集合
     */
    List<MallGoodsDto> listByActivityIds(List<Long> activityIds);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param pickActivityId 选品活动id
     * @return 符合条件的记录数
     */
    Long countByActivity(Long pickActivityId);

    /**
     * 修改选品状态
     *
     * @param id  选品id
     * @param oldPickStatus  选品的当前状态
     * @param newPickStatus 修改后的状态
     * @return 修改结果
     */
    boolean updatePickStatus(Long id, Integer oldPickStatus, Integer newPickStatus);


    /**
     * 修改选品状态-->选品入库
     *
     * @param id  选品id
     * @param oldPickStatus  选品的当前状态
     * @param newPickStatus 修改后的状态
     * @return 修改结果
     */
    boolean updatePickStatusToStore(Long id, Integer oldPickStatus, Integer newPickStatus);

    // ------------------------- 以下为供应商侧操作专用 ----------------------------

    /**
     * 供应商侧-选品分页列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<MallGoodsDto> thirdGoodsPageList(PickGoodsPageParam param);

    /**
     * 供应商侧-统计选品数量
     *
     * @param param 筛选条件
     * @return 选品数量
     */
    Long thirdGoodsCount(PickGoodsPageParam param);

    /**
     * 供应商-选品信息
     *
     * @param id 选品id
     * @param supplierId 供应商id
     * @return 选品信息
     */
    MallGoodsDto findByIdAndSupplier(Long id, Long supplierId);

    /**
     * 通过id和选品状态查询
     *
     * @param id         主键
     * @param pickStatus 选品状态
     * @return 商城-商品库
     */
    MallGoodsDto selectByIdAndPickStatus(Long id,Integer pickStatus);

    /**
     * 通过id和选品状态批量查询
     *
     * @param ids         主键
     * @param pickStatus 选品状态
     * @return 商城-商品库
     */
    List<MallGoodsDto> selectByIdsAndPickStatus(List<Long> ids,Integer pickStatus);
}