package cn.com.duiba.live.conf.service.api.enums.potential;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 对话类型枚举
 *
 * @author ZhangJun
 * @date 2021/8/19 11:46 上午
 */
@Getter
@AllArgsConstructor
public enum LiveDialogueTypeEnum {

    /**
     * 代理人欢迎语
     */
    AGENT_GREET(1, "代理人欢迎语"),

    /**
     * 推荐问题
     */
    QUESTION(2, "推荐问题"),

    /**
     * 承诺卡片
     */
    PROMISE_CARD(3, "承诺卡片"),

    /**
     * 客户行动承诺
     */
    CUSTOMER_PROMISE(4, "客户行动承诺"),

    /**
     * 代理人结束语
     */
    AGENT_CONCLUSION(5, "代理人结束语"),
    ;

    /**
     * 对话类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 所有枚举Map
     */
    private static final Map<Integer, LiveDialogueTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveDialogueTypeEnum::getType, Function.identity())));

    /**
     * 纯文案类型的对话Map
     */
    private static final Map<Integer, LiveDialogueTypeEnum> DIRECT_CONTENT_TYPE_MAP = Collections.unmodifiableMap(Lists.newArrayList(AGENT_GREET, CUSTOMER_PROMISE, AGENT_CONCLUSION).stream().collect(Collectors.toMap(LiveDialogueTypeEnum::getType, Function.identity())));

    /**
     * 是否存在此枚举类型
     *
     * @param type 对话类型
     * @return true-存在，false-不存在
     */
    public static boolean containsType(Integer type) {
        return ENUM_MAP.containsKey(type);
    }

    /**
     * 是否为纯文案类型的对话类型
     *
     * @param type 对话类型
     * @return true-是，false-否
     */
    public static boolean isDirectContent(Integer type) {
        return DIRECT_CONTENT_TYPE_MAP.containsKey(type);
    }

}
