package cn.com.duiba.live.conf.service.api.enums.round;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author guoxuebiao
 * @date 2021/6/11 6:33 下午
 */
@Getter
@AllArgsConstructor
public enum TimeRedTaskTypeEnum {


    NOT_CONFIG(0, "未配置"),
    WATCH_LIVE_ROOM(1, "关注直播间"),
    SAVE_POST(2, "保存海报"),
    RECEIVE_RESOURCE(3, "领取权益"),
    ;

    private final Integer type;
    private final String message;

    private static final Map<Integer, TimeRedTaskTypeEnum> TYPE_MAP = new HashMap<>();

    static {
        for (TimeRedTaskTypeEnum type : values()) {
            TYPE_MAP.put(type.getType(), type);
        }
    }

    public static TimeRedTaskTypeEnum getByType(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        return TYPE_MAP.get(type);
    }
}
