package cn.com.duiba.live.conf.service.api.remoteservice.popup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.popup.LiveAuthPopupDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-07-28 09:38
 * 授权弹窗 rpc service
 */
@AdvancedFeignClient
public interface RemoteAuthPopupApiService {

    /**
     * 根据直播id和场景值获取弹窗配置
     * @param liveId 直播id
     * @param scene 场景值
     * @see cn.com.duiba.live.conf.service.api.enums.popup.LiveAuthPopupSceneEnum
     * @return 弹窗配置
     */
    LiveAuthPopupDto findByLiveIdAndSceneFromCache(Long liveId, Integer scene);

    /**
     * 根据直播id获取所有弹窗配置
     * @param liveId 直播id
     * @return 弹窗配置
     */
    List<LiveAuthPopupDto> searchListFromCache(Long liveId);

    /**
     * 保存弹窗配置
     * @param liveAuthPopupDto 弹窗配置
     * @return 保存结果
     */
    int save(LiveAuthPopupDto liveAuthPopupDto);

    /**
     * 编辑弹窗配置
     * @param liveAuthPopupDto 弹窗配置
     * @return 保存结果
     */
    int update(LiveAuthPopupDto liveAuthPopupDto);
}
