package cn.com.duiba.live.conf.service.api.dto.mall.sku;

import lombok.Data;

import java.io.Serializable;

/**
 * 商城-规格库存单元
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@Data
public class MallGoodsSkuDto implements Serializable {
     
    private static final long serialVersionUID = 16589034868432244L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 业务类型，1=选品，2=商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.sku.SkuBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务id，如选品/商品id
     */
    private Long bizId;

    /**
     * 关联的库存id, tb_stock.id
     */
    private Long stockId;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 规格编码，同一供应商下唯一
     */
    private String skuCode;

    /**
     * 规格图片url
     */
    private String skuImg;

    /**
     * 供货价，单位：分
     */
    private Long supplyPrice;

    /**
     * 市场指导价，单位：分
     */
    private Long marketPrice;

    /**
     * 建议售价，单位：分
     */
    private Long suggestPrice;

    /**
     * 规格属性配置，格式为key:value，如1:2,3:4，多个属性以英文逗号隔开，key为tb_attribute_key.id，value为tb_attribute_value.id
     */
    private String attributeConfig;

}