package cn.com.duiba.live.conf.service.api.dto.red;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播配置-红包相关配置
 * 与 tb_live_conf_red_packet 表保持一致
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
public class LiveConfRedPacketDto implements Serializable {
     
    private static final long serialVersionUID = 158581531908280L;

    /**
     * 主键 tb_live_conf_red_packet.id
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包金额
     */
    private Integer amount;

    /**
     * 红包数量
     */
    private Integer num;

    /**
     * 展示金额
     */
    private Integer showAmount;

    /**
     * 展示数量
     */
    private Integer showNum;

    /**
     * 需要助力人数
     */
    private Integer helpNum;

    /**
     * 红包类型：
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketTypeEnum
     */
    private Integer redType;

    /**
     * 发放类型: 1:固定 2:随机
     * @see cn.com.duiba.live.conf.service.api.enums.live.LiveRedSendTypeEnum
     */
    private Integer sendType;

    /**
     * 红包状态：1-未发布，2-已发布，3-已结束
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketStatusEnum
     */
    private Integer redStatus;

    /**
     * 开抢时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 是否已删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 多少分钟之后开抢
     */
    private Integer afterMin;


    /**--------下列字段在重构完成后删除---------**/

    /**
     * 普通红包剩余金额
     */
    @Deprecated
    private Integer surplusAmount;

    /**
     * 普通红包剩余数量
     */
    @Deprecated
    private Integer surplusNum;

    /**
     * 手气王红包金额
     */
    @Deprecated
    private Integer luckAmount;

    /**
     * 手气王红包数量
     */
    @Deprecated
    private Integer luckNum;

    /**
     * 手气王红包剩余金额
     */
    @Deprecated
    private Integer luckSurplusAmount;

    /**
     * 手气王红包剩余数量
     */
    @Deprecated
    private Integer luckSurplusNum;

    /**
     * 手气王需要助力人数
     */
    @Deprecated
    private Integer luckHelpNum;

    /**
     * 总红包金额
     */
    @Deprecated
    public Integer getTotalAmount() {
        return amount + (luckAmount * luckNum);
    }

    /**
     * 总红包数量
     */
    @Deprecated
    public Integer getTotalNum() {
        return num + luckNum;
    }

    /**
     * 总红包剩余数量
     */
    @Deprecated
    public Integer getTotalSurplusNum() {
        return surplusNum + luckSurplusNum;
    }
}