package cn.com.duiba.live.conf.service.api.enums.flip.word;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 翻牌首邀玩法开关
 *
 * @author ZhangJun
 * @date 2021/9/28 9:52 上午
 */
@Getter
@AllArgsConstructor
public enum FlipWordFirstInviteStatusEnum {

    CLOSE(1, "关闭"),
    OPEN(2, "开启"),
    ;

    private final Integer status;
    private final String desc;

    private static final Map<Integer, FlipWordFirstInviteStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(FlipWordFirstInviteStatusEnum::getStatus, Function.identity())));
    }

    public static FlipWordFirstInviteStatusEnum getByStatus(Integer status) {
        if (Objects.isNull(status)) {
            return null;
        }

        return ENUM_MAP.get(status);
    }

}
