package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveBeautifyConfDto;

/**
 * 美颜配置
 * @author lizhi
 * @date 2020/5/15 10:15 AM
 */
@AdvancedFeignClient
public interface RemoteLiveBeautifyConfApiService {

    /**
     * 根据公司ID查询
     * @param companyId 公司ID
     * @return 直播美颜配置
     */
    LiveBeautifyConfDto findByCompanyId(Long companyId);

    /**
     * 根据公司ID新增或更新
     * @param dto 直播美颜配置
     * @return 执行结果
     */
    int saveOrUpdateByCompanyId(LiveBeautifyConfDto dto);
}
