/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.popup;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LiveAuthPopupSceneEnum {
    LIVE_LOTTERY(1, "\u76f4\u64ad\u62bd\u5956"),
    FISSION_TREASURE(2, "\u88c2\u53d8\u5b9d\u7bb1"),
    FLIP_WORD(3, "\u7ffb\u724c\u96c6\u5b57"),
    LUCKY_RED(4, "\u624b\u6c14\u738b\u7ea2\u5305"),
    GUESS_RED(5, "\u731c\u6570\u7ea2\u5305"),
    FORTUNE_RED(6, "\u597d\u8fd0\u7ea2\u5305"),
    QUESTION_RED(7, "\u95ef\u5173\u7b54\u9898"),
    DEGREE_NO_LOTTERY(8, "\u964d\u7ea7\u65e0\u62bd\u5956");

    private final Integer scene;
    private final String desc;
    private static final Map<Integer, LiveAuthPopupSceneEnum> SCENE_MAP;

    public static LiveAuthPopupSceneEnum getByScene(Integer scene) {
        if (Objects.isNull(scene)) {
            return null;
        }
        return SCENE_MAP.get(scene);
    }

    public Integer getScene() {
        return this.scene;
    }

    public String getDesc() {
        return this.desc;
    }

    private LiveAuthPopupSceneEnum(Integer scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    static {
        SCENE_MAP = Collections.unmodifiableMap(Arrays.stream(LiveAuthPopupSceneEnum.values()).collect(Collectors.toMap(LiveAuthPopupSceneEnum::getScene, Function.identity(), (v1, v2) -> v1)));
    }
}

