package cn.com.duiba.live.conf.service.api.dto.mall.marketing;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 支付后营销配置表
 *
 * @author kjj mybatis generator
 * @date 2022-11-08
 */
@Data
public class MallMarketingAfterPayConfDetailDto implements Serializable {

    private static final long serialVersionUID = 16678978739899054L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播Id
     */
    private Long liveId;

    /**
     * 弹窗图片
     */
    private String popImg;

    /**
     * 外链类型
     * {@link cn.com.duiba.live.conf.service.api.enums.resource.OutLinkTypeEnum}
     */
    private Integer outLinkType;

    /**
     * 外部链接
     */
    private String outLink;

    /**
     * 跳转appId，仅当外链类型为小程序时有值
     */
    private String outLinkAppId;

    /**
     * 配置id，仅当外链类型为银行类型时有值
     */
    private Long bizId;

    /**
     * 商品限制 1-全场通用 2-部分商品
     */
    private Integer goodsLimitFlag;

    /**
     * 商品id列表
     */
    private List<Long> goodsIdList;

}