package cn.com.duiba.live.conf.service.api.dto.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 商城-售卖商品表
 * @author kjj mybatis generator 
 * @date 2022-08-09
 */
@Data
public class MallSaleSpuDto implements Serializable {
     
    private static final long serialVersionUID = 16600253495388558L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品库商品id tb_mall_goods.id
     */
    private Long goodsId;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 品牌名称
     */
    private String goodsBrand;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 商品类型1-实物 2-虚拟商品
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.salegoods.GoodsTypeEnum}
     */
    private Integer goodsType;

    /**
     * 商品类目id，tb_goods_category.id
     */
    private Long categoryId;

    /**
     * 商品主图id集合，逗号分割 对应tb_common_img.id
     */
    private String mainImgIds;

    /**
     * 商品主图id集合，逗号分割 对应tb_common_img.id
     */
    private String detailImgIds;

    /**
     * 业务id 业务类型为1时 直播id
     */
    private Long bizId;

    /**
     * 业务类型 1-直播
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.MallBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     * 存储格式为json数组:  ["标签1","标签2","标签3"]
     */
    private List<String> subTag;

    /**
     * 是否支持七天无理由退货 0-不支持 1-支持
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer noReasonRefund;

    /**
     * 退货地址及联系方式等信息
     */
    private String refundInfo;

    /**
     * 最大购买数量限制
     */
    private Integer maxBuyNum;

    /**
     * 是否需要发货审核0-不需要 1-需要
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer deliveryAudit;

    /**
     * 限制购买地区编码
     */
    private String limitRegionCode;

    /**
     * 限制购买地区名称
     */
    private String limitRegionName;

    /**
     * 发货地
     */
    private String deliveryPlace;

    /**
     * 配送方式
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.salegoods.DeliveryWayTypeEnum}
     */
    private Integer deliveryWay;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 按钮标题
     */
    private String buttonTitle;

    /**
     * 创建时间
     */
    private Date gmtCreate;


    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 支付渠道列表 1-微信支付 2-银联趣分期
     */
    private List<Integer> payChannels;

    /**
     * 限制银行编码 支付渠道为趣分期才有
     */
    private List<String> restrictedBankCodes;

    /**
     * 持卡判断限制
     * 1-不限制 2-仅持卡人购买 3-仅非持卡人购买
     * {@link cn.com.duiba.live.conf.service.api.enums.bank.card.BankCardHoldLimitType}
     */
    private Integer cardHoldLimit;
}