package cn.com.duiba.live.conf.service.api.dto.vocher;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播代金券配置表
 * @author kjj mybatis generator
 * @date 2022-01-24
 */
@Data
public class LiveVoucherConfDto implements Serializable {

    private static final long serialVersionUID = 1643024295619795L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代金券面额，单位：分
     */
    private Integer voucherPrice;

    /**
     * 生效范围：1:秒杀全局 2:秒杀指定商品
     * @see cn.com.duiba.live.conf.service.api.enums.voucher.VoucherEffectiveScopeEnum
     */
    private Integer effectiveScope;

    /**
     * 券总数。-1:表示无限制
     */
    private Integer totalCount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
