package cn.com.duiba.live.conf.service.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 直播间配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
@Getter
public enum LiveExtEnum {

    INVITE_COUNT(1, "代理人指定中奖参与条件,邀请个数"),

    PRESENT_NUM(2, "直播到场人数"),

    LOTTERY_ONLY_SPECIFY(3, "暗箱-企业指定中奖人员，其他轮次是否可中奖"),

    LOTTERY_VEST_SPECIFY(4, "暗箱-企业指定中奖人员不足，未指定人员是否可中"),

    @Deprecated
    AWARW_GRANT_CHECK(5,"奖品发放配置-客户确认信息"),

    @Deprecated
    AWARW_GRANT_CHECK_RED(6,"奖品发放配置-客户确认信息红包"),

    @Deprecated
    AWARW_GRANT_ENTRANCE(7,"奖品发放配置-奖品签收入口"),

    AWARW_GRANT_QRCODE_URL(8,"奖品发放配置-奖品签收二维码"),

    MAX_SPECIFY_COUNT(9, "代理人指定中奖次数最大值"),

    @Deprecated
    AWARW_GRANT_SIGN_RED(10,"奖品发放配置-客户签收奖励红包"),

    LOTTERY_DIRECTLY(11, "抽奖-新老客户奖品分配"),

    LOTTERY_DIRECTLY_SCORE(12, "抽奖-新老客户奖品分配加分"),

    LIVE_DELAY_FLAG(13,"直播间延期标记"),

    LIVE_SECOND_VERYTICEL_POSYTER_URL(14,"直播宣传第二张竖版海报链接"),

    AGENT_INVITE_AUTH_TYPE(15, "代理人邀请权限类型"),

    AGENT_INVITE_AUTH_LIMIT_NUM(16, "代理人邀请权限限制人数"),

    AGENT_HAS_JOIN_NUM(17, "代理人已参与人数"),

    GOLD_SYNC_INFO(18, "国寿黄金宝典同步相关信息"),

    @Deprecated
    AWARW_GRANT_AGENT_CHECK_RED(21,"奖品发放配置-代理人确认信息红包"),

	SPECIFY_AWARD_PRIVILEGE_SCOPE(22,"指定中奖权限范围"),

    REWARD_AWAY_CHECK_CONF(23, "中奖名单核奖方式"),

    REWARD_RED_PACKET_CONF(24, "中奖名单红包配置"),

    AWARD_GRANT_SCAN_CODE(25, "奖品发放配置-扫码设置"),

    LIVE_RED_RULE(26, "直播答题有奖红包奖品规则"),

    LIVE_WELFARE_RULE(27, "直播答题有奖实物奖品规则"),

    LIVE_REGION_TYPE(28, "直播-指定区域配置"),

    LIVE_DISTRIBUTION_TYPE(29, "直播间奖品分发方式"),

    LIVE_TIMED_CHOICE_SWITCH_CONF(30, "直播间定时投票开关"),

    LIVE_TRANSITION_VIDEO_STATUS(31,"直播过渡视频开启状态"),

    LIVE_TRANSITION_VIDEO_TIME(32,"开播后XX秒后，播放过渡视频"),

    LIVE_TRANSITION_VIDEO_URL(33,"直播过渡视频链接"),

    LIVE_SERIES_POSTER_SWITCH_CONF(34, "直播系列海报配置开关"),

    LIVE_TIMED_RED_ROUND_SWITCH_CONF(35, "轮次红包开关"),

    LIVE_PRE_WINDOW_URL(36, "预告页弹窗图片"),

    LIVE_PRE_AWARD_URL(37, "预告页奖品图片"),

    LIVE_POTENTIAL_CUSTOMER_QUES_CONF(38, "直播潜在客户问题配置"),

    LIVE_FLIP_WORD_RED_SWITCH_CONF(40, "翻牌集字红包开关配置"),

    LIVE_AWARD_ADDERS_DEADLINE(41, "直播奖品邮寄地址填写截止时间"),

    LIVE_NEW_PREVIEW_OPEN_STATE(42, "新版预告页开启状态"),

    LIVE_NEW_PREVIEW_WELFARE(43, "新版预告页配置的主奖品ID"),

    LIVE_PRE_LAYER_OPEN(45, "直播预告页弹窗开关"),
    LIVE_PRE_HELP_LAYER_IMG(46, "预告页助力弹窗图片"),
    LIVE_PRE_BASE_INFO_LAYER_IMG(47, "预告页基础信息授权弹窗图片"),
    LIVE_PRE_PHONE_LAYER_IMG(48, "预告页手机号码授权弹窗图片"),
    LIVE_PRE_APPOINTMENT_LAYER_IMG(49, "预告页预约直播弹窗图片"),


    LIVE_PRE_IMG_A2(50, "预告页弹窗图片集A2版本，json格式"),
    LIVE_PRE_IMG_B1(51, "预告页弹窗图片集B1版本，json格式"),

    LIVE_TRANSITION_VIDEO_URL_B(52, "直播过渡视频链接B方案"),

    LIVE_NEW_PREVIEW_TITLE_IMG(53,"新版预告页标题图片"),

    LIVE_INFORM_A1(54,"直播服务通知-A1用户"),
    LIVE_INFORM_A2(55,"直播服务通知-A2用户"),
    LIVE_INFORM_B1(56,"直播服务通知-B1用户"),
    LIVE_INFORM_B2(57,"直播服务通知-B2用户"),

    LIVE_SECOND_KILL_PRE_IMG(58, "直播秒杀预告底图"),
    LIVE_SECOND_KILL_PRE_SWITCH(59, "直播秒杀预告开关"),

    LIVE_AGENT_INVITE_REWARD_OPEN_STATUS(60,"代理人邀约红包-配置开关"),

    LIVE_FLIP_WORD_RED_FREE_NUM(61, "翻牌红包免费次数"),
    LIVE_FLIP_WORD_RED_HELP_NUM(62, "翻牌红包助力次数"),
    LIVE_FLIP_WORD_RED_TITLE_IMAGE(63, "翻牌红包标题配图"),
    LIVE_FLIP_WORD_FIRST_INVITE_STATUS(64, "翻牌首邀玩法开关"),

    LIVE_KILL_GOODS_LIMIT_GROUP(65, "直播秒杀限制组"),

    LIVE_SPECIFY_AWARD_AGENT_SWITCH(66, "指定代理人中奖-配置开关"),
    LIVE_FOLLOW_PUSH_STATE(67, "关注直播间用户是否推送信息开关"),

    LIVE_NORMAL_RED_AUTO_RECEIVE(69, "普通红包自动发布开关"),
    LIVE_GUESS_RED_AUTO_RECEIVE(70, "猜数字红包自动发布开关"),
    LIVE_KILL_VOUCHER_OPEN(71, "直播秒杀代金券是否开启"),

    LIVE_TIME_TREASURE_SWITCH(72, "直播中时长宝箱开关"),

    LIVE_SPOKE_SWITCH(73, "直播弹幕评论开关"),

    LIVE_LOTTERY_RULE(74, "直播答题有奖抽奖券规则"),

    LIVE_QUES_REWARD_CLUE_USER_RULE(75, "直播答题线索员规则"),

    LIVE_AGENT_INVITE_CODE_SWITCH(76, "面签码上传入口开关"),
    LIVE_AGENT_INVITE_CODE_TYPE(77, "面签码类型"),

    LIVE_PREVIEW_PAGE_VERSION(78,"预告页UI版本"),

    LIVE_PREVIEW_MALL_BANNER(79,"预告页商城版本banner图片"),

    LIVE_PREVIEW_MALL_GOODS_LIST(80,"预告页展示的商城商品列表"),

    LIVE_POTENTIAL_SWITCH(81, "准客户功能开启"),

    LIVE_JOIN_AGENT_NUM_RESOURCE_SET(82, "直播-拼接代理人-资料id集合"),
    LIVE_JOIN_AGENT_NUM_BANK_CARD_SET(83, "直播-拼接代理人-办卡配置type集合"),

    LIVE_ENABLE_SHARE_SWITCH(84, "直播分享开关"),

    LIVE_LOTTERY_GOODS_LIST(85, "直播抽奖商品列表"),

    LIVE_LOTTERY_TURN_SHOW_FLAG(86, "直播轮次开关"),

    LIVE_PRE_LOTTERY_TASK_TYPE(87, "预告页抽奖任务类型"),

    NON_AGENT_INVITE_USER_LOTTERY_RULE(88,"非代理人邀请客户中奖规则"),
    ;

    /**
     * 键  长度限制64
     */
    private Integer key;
    /**
     * 描述  长度限制1024
     */
    private String desc;


    LiveExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }


    private static final Map<Integer, LiveExtEnum> ENUM_MAP = new HashMap<>();

    /**
     * 直播中过渡视频相关配置
     */
    private static final List<Integer> TRANSITION_VIDEO_KEY = Collections.unmodifiableList(Arrays.asList(LiveExtEnum.LIVE_TRANSITION_VIDEO_STATUS.getKey(), LiveExtEnum.LIVE_TRANSITION_VIDEO_TIME.getKey(), LiveExtEnum.LIVE_TRANSITION_VIDEO_URL.getKey(),LIVE_TRANSITION_VIDEO_URL_B.getKey()));

    /**
     * 直播前预告页弹窗相关配置
     */
    public static final List<Integer> LIVE_PRE_LAYER_KEY = Collections.unmodifiableList(Arrays.asList(LiveExtEnum.LIVE_PRE_LAYER_OPEN.getKey(), LiveExtEnum.LIVE_PRE_HELP_LAYER_IMG.getKey(), LiveExtEnum.LIVE_PRE_BASE_INFO_LAYER_IMG.getKey(), LiveExtEnum.LIVE_PRE_PHONE_LAYER_IMG.getKey(), LiveExtEnum.LIVE_PRE_APPOINTMENT_LAYER_IMG.getKey()));
    /**
     * 预告页弹窗，图片相关配置
     */
    private static final List<Integer> PRE_LIVE_IMG_KEY = Collections.unmodifiableList(Arrays.asList(LiveExtEnum.LIVE_PRE_WINDOW_URL.getKey(), LiveExtEnum.LIVE_PRE_AWARD_URL.getKey()));

    static{
        for(LiveExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveExtEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key){
        if (StringUtils.isBlank(key)){
            return false;
        }
        for (LiveExtEnum enumVal : LiveExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 获取直播中过渡视频相关配置keys
     */
    public static List<Integer> transitionVideoKeys(){
        return TRANSITION_VIDEO_KEY;
    }

    /**
     * 获取预告页弹窗相关配置keys
     */
    public static List<Integer> getPreLiveImgKey(){
        return PRE_LIVE_IMG_KEY;
    }
}
