package cn.com.duiba.live.conf.service.api.param.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商品编辑参数
 *
 * @author ZhangJun
 * @date 2022/7/25 19:24
 */
@Data
public class SaleGoodsUpdateMngParam implements Serializable {

    private static final long serialVersionUID = -7690553806745600821L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 直播商品id = spuId
     * 请使用spuId
     */
    @Deprecated
    private Long liveGoodsId;

    /**
     * 配置id
     */
    private Long confId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 品牌名
     */
    private String goodsBrand;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 主图id集合
     */
    private List<Long> mainImgIds;

    /**
     * 详情图id集合
     */
    private List<Long> detailImgIds;

    /**
     * 发货地
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 是否支持七天无理由退货
     * 0=否，1=是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer noReasonRefund;

    /**
     * 退换货地址等信息
     */
    private String refundInfo;

    /**
     * 发货审核设置
     * 0=否，1=是
     * {@link cn.com.duiba.live.conf.service.api.enums.BooleanEnum}
     */
    private Integer deliveryAudit;

    /**
     * 最大购买限制
     */
    private Integer maxBuyNum;

    /**
     * 限制地区代码
     */
    private String limitRegionCode;

    /**
     * 限制地区名称
     */
    private String limitRegionName;

    /**
     * 橱窗按钮标题文案
     */
    private String buttonTitle;

    /**
     * 主标签 图片url
     */
    private String mainTag;

    /**
     * 配送方式 1-订单配送 2-线下自送
     */
    private Integer deliveryWay;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 支付渠道
     */
    private List<Integer> payChannels;

    /**
     * 支持的银行编码
     */
    private List<String> restrictedBankCodes;

    /**
     * 持卡判断限制
     * 1-不限制 2-仅持卡人购买 3-仅非持卡人购买
     * {@link cn.com.duiba.live.conf.service.api.enums.bank.card.BankCardHoldLimitType}
     */
    private Integer cardHoldLimit;
}
