package cn.com.duiba.live.conf.service.api.dto.pass;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 闯关答题问题配置 redis dto
 * @author chentiecheng
 * @date 2021-06-18
 */
@Data
public class LivePassQuesConfRedisDto implements Serializable {


    private static final long serialVersionUID = 7477443353078261009L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 问题状态
     * @see cn.com.duiba.live.conf.service.api.enums.pass.LivePassQuesStatusEnum
     */
    private Integer quesStatus;

    /**
     * 预计答题时间，相对于开播时间后几分钟
     */
    private Integer openTime;
    /**
     * 实际发放时间
     */
    private Date pushTime;
    /**
     * 问题内容
     */
    private String passQuestion;

    /**
     * 问题选项列表
     */
    private List<LivePassQuesOptionRedisDto> options;
}