package cn.com.duiba.live.conf.service.api.enums.fortune;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author gxy
 * @date 2021/7/6 12:00 下午
 */
@Getter
@AllArgsConstructor
public enum FortuneRedTypeEnum {
    FIXED(1, "固定类型"),
    RANDOM(2, "随机类型"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, FortuneRedTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(FortuneRedTypeEnum::getType, Function.identity())));

    private static final Set<Integer> TYPES = Collections.unmodifiableSet(Arrays.stream(values()).map(FortuneRedTypeEnum::getType).collect(Collectors.toSet()));

    /**
     * 获取对应的枚举实例
     */
    public static FortuneRedTypeEnum getEnumItem(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return null;
        }
        return ENUM_MAP.get(sendType);
    }

    /**
     * 判断type是否属于枚举
     */
    public static boolean contains(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return TYPES.contains(type);
    }
}
