package cn.com.duiba.live.conf.service.api.enums.treasure;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 吴文哲
 * @date 2021/4/8 2:47 下午
 **/
@Getter
@AllArgsConstructor
public enum TreasureTypeEnums {

    /**
     * 宝箱类型枚举
     */
    LOTTERY_CODE(1,"抽奖码"),
    RED_PACKET(2,"现金红包"),
    ENTITY_AWARD(3,"实物奖品"),
    TEAM_AWARD(4,"团队奖品"),
    ;

    /**
     * 宝箱类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, TreasureTypeEnums> ENUM_MAP = new HashMap<>();

    static{
        for(TreasureTypeEnums typeEnums : values()){
            ENUM_MAP.put(typeEnums.getType(), typeEnums);
        }
    }

    public static TreasureTypeEnums getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
