package cn.com.duiba.live.conf.service.api.param.voucher;

import lombok.Data;

import java.io.Serializable;

/**
 * @author dugq
 * @date 2022/1/24 8:26 下午
 */
@Data
public class VoucherSaveParam implements Serializable {
    private static final long serialVersionUID = -3652675775804889875L;

    /**
     * 配置ID
     */
    private Long id;


    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代金券面额，单位：分
     */
    private Integer voucherPrice;

    /**
     * 生效范围：1:秒杀全局商品 2:秒杀指定商品
     *
     * @see cn.com.duiba.live.conf.service.api.enums.voucher.VoucherEffectiveScopeEnum
     */
    private Integer effectiveScope=1;

    /**
     * 券总数。-1:表示无限制
     */
    private Integer totalCount=-1;


    /**
     * 邀请多少人可换取一张券
     */
    private Integer invitationNumPerVoucher;

    /**
     * 每个代理人最多可获得多少张 -1：无限制
     */
    private Integer maxCountPerAgent;
}
