package cn.com.duiba.live.conf.service.api.remoteservice.mall.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.common.MallGoodsCategoryDto;

import java.util.List;

/**
 * 商城-商品类目表
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsCategoryService {

    /**
     * 新增
     * @param dto 商城-商品类目
     * @return 执行结果
     */
    boolean insert(MallGoodsCategoryDto dto);

    /**
     * 批量插入
     *
     * @param categoryDtoList 商城-商品类目
     * @return 执行结果
     */
    boolean batchInsert(List<MallGoodsCategoryDto> categoryDtoList);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城-商品类目
     */
    MallGoodsCategoryDto selectById(Long id);

    /**
     * 查询所有
     *
     * @return 查询所有
     */
    List<MallGoodsCategoryDto> listAll();

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 商品类目列表
     */
    List<MallGoodsCategoryDto> listByIds(List<Long> ids);

}