package cn.com.duiba.live.conf.service.api.dto.form;

import lombok.Data;

import java.io.Serializable;

/**
 * 表单字段表
 * @author kjj mybatis generator 
 * @date 2020-07-25
 */
@Data
public class FormFieldDto implements Serializable {
     
    private static final long serialVersionUID = 15956709507112766L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 字段名称（姓名、电话）
     */
    private String fieldName;

    /**
     * 字段类型 1-单行文本 2-电话
     * @see cn.com.duiba.kjy.livecenter.api.enums.form.FormFieldTypeEnum
     */
    private Integer fieldType;

    /**
     * 字段简写名称（name、phoneNumber）
     */
    private String fieldShortName;

    /**
     * 表单业务id（tb_resource.id）
     */
    private Long fieldBizId;

    /**
     * 表单业务类型 1-资料
     * @see cn.com.duiba.kjy.livecenter.api.enums.form.FormBizTypeEnum
     */
    private Integer fieldBizType;

    /**
     * 填写类型，1-必填，2-非必填
     * @see cn.com.duiba.kjy.livecenter.api.enums.form.FormFieldSelectTypeEnum
     */
    private Integer fieldSelectType;

    /**
     * 启用状态 0-未启用 1-已启用
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer enabledStatus;
}