package cn.com.duiba.live.conf.service.api.enums.company;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022-1-10 11:14
 * @description 公司类型枚举
 */
@Getter
@AllArgsConstructor
public enum CompanyBusinessTypeEnum {

    INSURANCE(1, "保险"),
    BANK(2, "银行"),
    ;

    private final Integer code;
    private final String description;

    private static final Map<Integer, CompanyBusinessTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(CompanyBusinessTypeEnum.values()).collect(Collectors.toMap(
                    CompanyBusinessTypeEnum::getCode,
                    Function.identity(),
                    (v1, v2) -> v2)
            )
    );

    public static CompanyBusinessTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }
}
