package cn.com.duiba.live.conf.service.api.enums.mall.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/09/15 15:32
 * @description 商城 - 优惠券状态
 */
@Getter
@AllArgsConstructor
public enum MallCouponStatusEnum {

    WAIT_DISTRIBUTE(1, "未发放"),
    DISTRIBUTING(2, "发放中"),
    MANUAL_INVALID(3, "手动失效"),
    LIVE_END_INVALID(4, "直播结束自动失效"),

    ;
    private final Integer status;
    private final String desc;

    /**
     * 优惠券最终状态
     */
    public static final List<Integer> END_STATUS_LIST = Collections.unmodifiableList(Arrays.asList(
            MANUAL_INVALID.getStatus(),
            LIVE_END_INVALID.getStatus()
    ));

    private static final Map<Integer, MallCouponStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    MallCouponStatusEnum::getStatus,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static MallCouponStatusEnum getByStatus(Integer type) {
        return ENUM_MAP.get(type);
    }

}
