package cn.com.duiba.live.conf.service.api.param.mall.coupon;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 商城-优惠券
 *
 * @author kjj mybatis generator
 * @date 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MallCouponSearchParam extends PageQuery {

    private static final long serialVersionUID = 16632098752797404L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 业务id 1-直播id
     */
    private Long bizId;

    /**
     * 场景类型 1-直播
     */
    private Byte bizType;

    /**
     * 优惠券类型 1-满减券
     */
    private Byte couponType;

    /**
     * 状态 1-生效中 2-已失效
     */
    private Byte couponStatus;

    /**
     * 优惠金额
     */
    private Integer discountAmount;

    /**
     * 使用门槛
     */
    private Integer useThreshold;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 限制规则
     */
    private String limitConf;
}