package cn.com.duiba.live.conf.service.api.param.resource;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播测试类型资料库
 * @author kjj mybatis generator 
 * @date 2021-03-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ResourceTestSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16145834972517155L;

    /**
     * 主键
     */
    private Long id;

    /**
     * tb_resource表主键ID
     */
    private Long resourceId;

    /**
     * 测试类型：1-增员秒薪
     */
    private Byte testType;

    /**
     * 线索类型：1-领取门票 2-发起咨询
     */
    private Byte clueType;

    /**
     * 公司行业介绍图片,逗号分隔
     */
    private String tradeIntroducePictures;

    /**
     * 悬浮图片
     */
    private String suspendImg;

    /**
     * 主按钮文案
     */
    private String mainButtonTitle;

    /**
     * 营销按钮文案
     */
    private String saleButtonTitle;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Byte deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}