package cn.com.duiba.live.conf.service.api.remoteservice.mall.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.coupon.MallCouponDto;

import java.util.List;

/**
 * 商城 - 优惠券
 *
 * @author kjj mybatis generator
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallCouponService {

    /**
     * 新增
     *
     * @param dto 优惠券详情
     * @return 执行结果
     */
    int insert(MallCouponDto dto);

    /**
     * 更新
     *
     * @param dto 优惠券详情
     * @return 执行结果
     */
    int update(MallCouponDto dto);

    /**
     * 根据优惠券Id查询
     *
     * @param id 优惠券Id
     * @return 优惠券详情
     */
    MallCouponDto findById(Long id);

    /**
     * 根据业务类型、业务Id查询, 根据创建时间倒序排列
     *
     * @param bizId   业务Id
     * @param bizType 业务类型
     * @return 优惠券列表
     */
    List<MallCouponDto> listByBizIdAndBizType(Long bizId, Integer bizType);

    /**
     * 优惠券失效
     *
     * @param id 优惠券id
     * @return 执行结果
     */
    int disableCoupon(Long id);

}