package cn.com.duiba.live.conf.service.api.remoteservice.teamassign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.teamassign.LiveConfPrizeTeamDto;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;

import java.util.List;

/**
 * 直播答题领奖按团队分配
 * @author gxy
 * @date 2021/4/16
 */

@AdvancedFeignClient
public interface RemoteLiveConfPrizeTeamService {

    /**
     * 根据confId查询
     *
     * @param confId 配置id
     * @return 结果列表
     */
    List<LiveConfPrizeTeamDto> selectByConfId(Long confId);

    /**
     * 根据配置，查询所有的团队ID
     * @param confId 配置ID
     * @return 团队ID
     */
    List<Long> selectTeamIdsByConfId(Long confId);

    /**
     * 分页查询
     * @param confId 配置ID
     * @param pageQuery 分页参数
     * @return 结果列表
     */
    List<LiveConfPrizeTeamDto> selectByConfIdPage(Long confId, PageQuery pageQuery);

    //=====以下为管理后端专用=====

    /**
     * 批量添加team到配置列表
     *
     * @param teams 团队
     * @return 添加状态
     */
    boolean addTeamList(List<LiveConfPrizeTeamDto> teams);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据confId删除所有
     *
     * @param confId 配置id
     * @return 删除条数
     */
    int deleteAllByConfId(long confId);

    /**
     * 根据teamId和liveIds删除所有
     * @param teamId 团队id
     * @param liveIdList 直播ID集合
     * @return 删除条数
     */
    int deleteByTeamIdAndLiveIds(Long teamId, List<Long> liveIdList);

    /**
     * 管理后端分页查询专用，查询配置的团队数
     *
     * @param confId 轮次规则配置id tb_live_ques_reward_conf.id
     * @return 符合条件的记录数
     */
    long selectCountByConfId(Long confId);
}
