package cn.com.duiba.live.conf.service.api.enums.conf;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
public enum LiveInteractTypeEnum {

    MATERIAL(1,"图文资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    CHOICE(8,"测一测"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
    FREE_RESOURCE(11, "免费领资料"),
    FORM_RESOURCE(12, "表单资料"),
    TEST_RESOURCE(13,"测试资料"),
    GAME_RESOURCE(14,"小游戏资料"),
    QUES_REWARD(15, "答题领奖"),
    FISSION_TREASURE_AWARD(16, "裂变宝箱奖品"),
    TIME_TREASURE_AWARD(17, "停留时长宝箱奖品"),
    TIMED_CHOICE(18, "推送定时投票"),
    TREASURE_TEAM_AWARD(19, "宝箱-团队奖励"),
    BUY_INSURANCE_AWARD(20, "直播中购买保险-奖励"),
    LIVE_SURVEY_AWARD(21, "直播中提交问卷-奖励"),
    LIVE_SECOND_KILL_GOODS(22, "秒杀商品"),
    EVALUATION_RESOURCE(23, "测评资料"),
    GOLDEN_EGG_TREASURE_AWARD(24, "砸金蛋宝箱奖品"),
    LIVE_SURVEY_REWARD(25, "直播问券有奖"),
    MALL_SALE_GOODS(26, "直播商城售卖商品"),
    MALL_LIVING_LOTTERY(27, "直播中抽奖-商城版"),
    MALL_FISSION_TREASURE_AWARD(28, "裂变宝箱-商城版"),
    MALL_TIME_TREASURE_AWARD(29, "时长宝箱-商城版"),
    MALL_FREE_GET(30, "免费领-商城版"),
    MALL_GOLDEN_EGG_TREASURE_AWARD(31, "砸金蛋-商城版"),
    MALL_QUES_REWARD(32, "有奖答题-商城版"),
    MALL_LIVE_SURVEY_AWARD(33, "问卷有奖-商城版"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveInteractTypeEnum(Integer type , String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 我的福利列表权益类型
     */
    public static List<Integer> welfareTypes = Lists.newArrayList();

    static {
        welfareTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(), FREE_GET.getType(),GRAB_WELFARE.getType(), MATERIAL.getType(), LINK_RESOURCE.getType()));
    }

    public static boolean isWelfare(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTypes.contains(type);
    }

    /**
     * 资料类型
     * @deprecated  ！important 以前把以资料结尾的几种具体类型，放一个集合中，统称为【资料】，但随着业务发展此定义不再适用。
     * ！important 在具体使用时，根据需求组装自己的集合
     */
    @Deprecated
    public static final List<Integer> resourceTypes = Lists.newArrayList();

    static {
        resourceTypes.addAll(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType(), TEST_RESOURCE.getType() ,GAME_RESOURCE.getType(), EVALUATION_RESOURCE.getType()));
    }

    /**
     * @see cn.com.duiba.live.conf.service.api.enums.live.LiveResourceTypeEnum#isResourceInteract(Integer)
     * @param type
     * @return
     */
    @Deprecated
    public static boolean isResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return resourceTypes.contains(type);
    }

    /**
     * 权益库类型
     */
    public static List<Integer> welfareTableTypes = Lists.newArrayList();

    static {
        welfareTableTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),
                FREE_GET.getType(),GRAB_WELFARE.getType(), FISSION_TREASURE_AWARD.getType(), TIME_TREASURE_AWARD.getType(),
                TREASURE_TEAM_AWARD.getType(), QUES_REWARD.getType(),BUY_INSURANCE_AWARD.getType(),LIVE_SURVEY_AWARD.getType(),
                GOLDEN_EGG_TREASURE_AWARD.getType(), LIVE_SURVEY_REWARD.getType(), MALL_LIVING_LOTTERY.getType(),
                MALL_FISSION_TREASURE_AWARD.getType(), MALL_GOLDEN_EGG_TREASURE_AWARD.getType(), MALL_FREE_GET.getType(),
                MALL_TIME_TREASURE_AWARD.getType(), MALL_QUES_REWARD.getType(), MALL_LIVE_SURVEY_AWARD.getType()));
    }
    
    public static final List<Integer> MALL_TYPE_LIST = Arrays.asList( MALL_LIVING_LOTTERY.getType(), MALL_FISSION_TREASURE_AWARD.getType(), MALL_TIME_TREASURE_AWARD.getType(),
            MALL_QUES_REWARD.getType(), MALL_LIVE_SURVEY_AWARD.getType(),  MALL_GOLDEN_EGG_TREASURE_AWARD.getType(), MALL_FREE_GET.getType());

    public static  final List<Integer> LOTTERY_INTERACT_TYPE_LIST = Arrays.asList(LiveInteractTypeEnum.GRAB_WELFARE.getType(), LiveInteractTypeEnum.MALL_LIVING_LOTTERY.getType());
    public static boolean isWelfareTable(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTableTypes.contains(type);
    }

    /**
     * 优质线索权益类型
     */
    private static List<Integer> highQualityWelfareTypes = Lists.newArrayList();

    static {
        highQualityWelfareTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), MALL_FREE_GET.getType()));
    }

    public static List<Integer> getHighQualityWelfareTypes() {
        return highQualityWelfareTypes;
    }

    public static boolean isHighQualityWelfareType(Integer type) {
        return highQualityWelfareTypes.contains(type);
    }

    /**
     * 优质线索资料类型
     */
    private static List<Integer> highQualityResourceTypes = Lists.newArrayList();

    static {
        highQualityResourceTypes.addAll(Lists.newArrayList(FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getHighQualityResourceTypes() {
        return highQualityResourceTypes;
    }

    public static boolean isHighQualityResourceType(Integer type) {
        return highQualityResourceTypes.contains(type);
    }

    /**
     * 普通资料类型（除表单资料和免费领资料外的其他资料）
     */
    private static final List<Integer> normalResourceTypes = Lists.newArrayList();

    static {
        normalResourceTypes.addAll(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType()));
    }

    public static boolean isNormalResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return normalResourceTypes.contains(type);
    }

    /**
     * 优质线索互动类型
     */
    private static List<Integer> highQualityTypes = Lists.newArrayList();

    static {
        highQualityTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getHighQualityTypes() {
        return highQualityTypes;
    }

    /**
     * 线索互动类型（中奖，免费领，以及所有资料）
     */
    private static List<Integer> clueInteractTypes = Lists.newArrayList();

    static {
        clueInteractTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), MALL_FREE_GET.getType(), MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getClueInteractTypes() {
        return clueInteractTypes;
    }

    private static List<Integer> mallGoodsTypes;

    static {
        mallGoodsTypes = Collections.unmodifiableList(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType(), TEST_RESOURCE.getType(), GAME_RESOURCE.getType(), EVALUATION_RESOURCE.getType(), MALL_SALE_GOODS.getType()));
    }

    public static List<Integer> getMallGoodsTypes() {
        return mallGoodsTypes;
    }

    /**
     * 旧版宝箱实物奖励集合
     */
    public static final List<Integer> TREASURE_AWARD_LIST = Collections.unmodifiableList(Arrays.asList(
            FISSION_TREASURE_AWARD.getType(),
            TIME_TREASURE_AWARD.getType(),
            GOLDEN_EGG_TREASURE_AWARD.getType()
    ));

    /**
     * 商城版宝箱实物奖励集合
     */
    public static final List<Integer> MALL_TREASURE_AWARD_LIST = Collections.unmodifiableList(Arrays.asList(
            MALL_FISSION_TREASURE_AWARD.getType(),
            MALL_TIME_TREASURE_AWARD.getType(),
            MALL_GOLDEN_EGG_TREASURE_AWARD.getType()
    ));

}
